#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ITERACIJE 5000

typedef struct {
    long long x, y;
    int index;
} Vektor;

void resavaj(int N, Vektor *vektori, long long Dx, long long Dy, unsigned long long *max_kvadrat, int *izabrano_best, int *izabrano_temp);

int main() {
    srand(time(NULL));

    int N;
    if (scanf("%d", &N) != 1 || N < 1) return 1;

    Vektor *vektori = (Vektor *)malloc(N * sizeof(Vektor));
    int *izabrano_best = (int *)calloc(N, sizeof(int));
    int *izabrano_temp = (int *)calloc(N, sizeof(int));
    
    if (vektori == NULL || izabrano_best == NULL || izabrano_temp == NULL) {
        if (vektori) free(vektori);
        if (izabrano_best) free(izabrano_best);
        if (izabrano_temp) free(izabrano_temp);
        return 1;
    }

    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &vektori[i].x, &vektori[i].y) != 2) {
            free(vektori); free(izabrano_best); free(izabrano_temp);
            return 1;
        }
        vektori[i].index = i + 1;
    }

    unsigned long long max_kvadrat = 0;

    resavaj(N, vektori, 1, 0, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, 0, 1, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, -1, 0, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, 0, -1, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, 1, 1, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, 1, -1, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, -1, 1, &max_kvadrat, izabrano_best, izabrano_temp);
    resavaj(N, vektori, -1, -1, &max_kvadrat, izabrano_best, izabrano_temp);

    for (int iter = 0; iter < ITERACIJE; iter++) {
        long long rx = (rand() % 2001) - 1000;
        long long ry = (rand() % 2001) - 1000;
        
        if (rx == 0 && ry == 0) rx = 1;

        resavaj(N, vektori, rx, ry, &max_kvadrat, izabrano_best, izabrano_temp);
    }
    
    int k = 0;
    for (int i = 0; i < N; i++) {
        if (izabrano_best[i]) {
            k++;
        }
    }

    printf("%d\n", k);
    
    int prvi = 1;
    for (int i = 0; i < N; i++) {
        if (izabrano_best[i]) {
            if (!prvi) {
                printf(" ");
            }
            printf("%d", vektori[i].index);
            prvi = 0;
        }
    }
    if (k > 0) {
        printf("\n");
    }

    free(vektori); 
    free(izabrano_best);
    free(izabrano_temp);

    return 0;
}

void resavaj(int N, Vektor *vektori, long long Dx, long long Dy, unsigned long long *max_kvadrat, int *izabrano_best, int *izabrano_temp) {
    long long Rx = 0;
    long long Ry = 0;
    
    for (int i = 0; i < N; i++) {
        if (vektori[i].x * Dx + vektori[i].y * Dy > 0) {
            Rx += vektori[i].x;
            Ry += vektori[i].y;
            izabrano_temp[i] = 1;
        } else {
            izabrano_temp[i] = 0;
        }
    }

    unsigned long long absRx = (Rx < 0) ? (unsigned long long)-Rx : (unsigned long long)Rx;
    unsigned long long absRy = (Ry < 0) ? (unsigned long long)-Ry : (unsigned long long)Ry;
    unsigned long long novi_kvad = absRx * absRx + absRy * absRy;

    if (novi_kvad > *max_kvadrat) {
        *max_kvadrat = novi_kvad;
        for (int i = 0; i < N; i++) {
            izabrano_best[i] = izabrano_temp[i];
        }
    }
}